from flask import Flask, render_template, jsonify, request
import os
import pymysql
from colorama import init, Fore
import datetime

app = Flask(__name__)

# Conectar ao banco de dados
conn = pymysql.connect(host='localhost', user='rbigols', password='32513683', database='consulta')
cursor = conn.cursor()

init(autoreset=True)  # Inicializa o colorama

indexando = False  # Variável para controlar a indexação

@app.route('/')
def index():
    return render_template('index.html')

# Restante do seu código...

@app.route('/indexar')
def indexar():
    global indexando
    
    pasta_audios = os.path.join(os.path.dirname(__file__), '..', 'audios')
    
    if not os.path.isdir(pasta_audios):
        return 'Pasta de áudios não encontrada.'
    
    indexando = True  # Inicia a indexação
    
    registros_a_inserir = []  # Lista para armazenar os registros a serem inseridos
    arquivos_verificados = set()  # Conjunto para armazenhar caminhos já verificados
    
    # Verifica quais arquivos já estão no banco de dados e os armazena no conjunto
    cursor.execute("SELECT filepath FROM audio")
    resultados = cursor.fetchall()
    for resultado in resultados:
        arquivos_verificados.add(resultado[0])
    
    for root, dirs, files in os.walk(pasta_audios):
        if not indexando:  # Verifica se a indexação deve ser interrompida
            break
        
        for file in files:
            if file.endswith(('.wav', '.gsm')):
                caminho_completo = os.path.join(root, file)
                
                # Obtendo o caminho relativo ao diretório 'audios'
                caminho_relativo = os.path.relpath(caminho_completo, pasta_audios)
                
                if caminho_relativo in arquivos_verificados:
                    continue  # Arquivo já existe no banco, passa para o próximo
                    
                partes_caminho = caminho_relativo.split(os.sep)
                if len(partes_caminho) < 4:
                    continue  # Estrutura de diretórios inválida
                
                # A estrutura esperada é: 'audios/servidor/ano/mes/dia/arquivo'
                servidor, ano, mes, dia, nome_arquivo = partes_caminho[:5]  # Captura as partes da data
                data_formatada = f"{ano}-{mes}-{dia}"
                
                caminho_arquivo = '/'.join(partes_caminho[1:])  # Obtém o caminho a partir de 'servidor' para frente
                
                nome_arquivo = file
                caminho_arquivo = caminho_relativo
                print(Fore.YELLOW + f"NOVO: {caminho_relativo}")
                
                # Adiciona os dados à lista para inserção em lote
                registros_a_inserir.append((servidor, data_formatada, nome_arquivo, caminho_arquivo))
                
    # Insere os registros em lote
    try:
        if registros_a_inserir:
            cursor.executemany("INSERT INTO audio (servidor, data, filename, filepath) VALUES (%s, %s, %s, %s)", registros_a_inserir)
            conn.commit()
            for registro in registros_a_inserir:
                print(Fore.GREEN + f"ADICIONADO: {registro[3]}")
            quantidade_inserida = len(registros_a_inserir)
        else:
            quantidade_inserida = 0
            
        # Obtendo a hora da execução
        #hora_execucao = datetime.datetime.now().strftime("%H:%M:%S")
        
        print(Fore.YELLOW + f"Total adicionado na ultima execução: {quantidade_inserida}")
        #print(f"Finalizou as: {hora_execucao}")
        
    except Exception as e:
        conn.rollback()
        quantidade_inserida = 0
    
    indexando = False  # Marca a indexação como concluída
    return str(quantidade_inserida)

@app.route('/parar_indexacao', methods=['POST'])
def parar_indexacao():
    global indexando
    indexando = False
    return 'Indexação interrompida pelo usuário'

if __name__ == '__main__':
    app.run(debug=True)